/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.IAttributeSet;
import noppes.npcs.api.entity.data.ICustomDrop;
import noppes.npcs.api.entity.data.IDropNbtSet;
import noppes.npcs.api.entity.data.IEnchantSet;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.api.handler.data.IQuestCategory;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.NBTWrapper;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.data.AttributeSet;
import noppes.npcs.entity.data.DataInventory;
import noppes.npcs.entity.data.DropNbtSet;
import noppes.npcs.entity.data.EnchantSet;
import noppes.npcs.util.Util;
import noppes.npcs.util.ValueUtil;

public class DropSet
implements IInventory,
ICustomDrop {
    private final Map<String, Integer> attributeSlotsName;
    private final DataInventory npcInv;
    public List<AttributeSet> attributes = new ArrayList<AttributeSet>();
    public List<EnchantSet> enchants = new ArrayList<EnchantSet>();
    public List<DropNbtSet> tags = new ArrayList<DropNbtSet>();
    public IItemStack item = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(ItemStack.field_190927_a);
    public int questId = 0;
    public int pos = 0;
    public int npcLevel;
    public int[] amount = new int[]{1, 1};
    public float damage = 1.0f;
    public double chance = 100.0;
    public int lootMode = 0;
    public boolean tiedToLevel = false;

    public DropSet(DataInventory ni) {
        this.npcInv = ni;
        HashMap<String, Integer> sln = new HashMap<String, Integer>();
        sln.put("mainhand", 0);
        sln.put("offhand", 1);
        sln.put("feet", 2);
        sln.put("legs", 3);
        sln.put("chest", 4);
        sln.put("head", 5);
        this.attributeSlotsName = sln;
        this.npcLevel = ni == null ? 1 : ni.npc.stats.getLevel();
    }

    public IAttributeSet addAttribute(IAttributeSet attribute) {
        this.attributes.add((AttributeSet)attribute);
        return attribute;
    }

    @Override
    public IAttributeSet addAttribute(String attributeName) {
        AttributeSet newAS = new AttributeSet(this);
        newAS.setAttribute(attributeName);
        this.attributes.add(newAS);
        return newAS;
    }

    public IDropNbtSet addDropNbtSet(IDropNbtSet nbtDS) {
        this.tags.add((DropNbtSet)nbtDS);
        return nbtDS;
    }

    @Override
    public IDropNbtSet addDropNbtSet(int type, double chance, String path, String[] values) {
        DropNbtSet dns = new DropNbtSet(this);
        dns.setType(type);
        dns.setChance(chance);
        dns.setPath(path);
        dns.setValues(values);
        this.tags.add(dns);
        return dns;
    }

    public IEnchantSet addEnchant(Enchantment enchant) {
        if (enchant != null) {
            EnchantSet newES = new EnchantSet(this);
            newES.setEnchant(enchant);
            this.enchants.add(newES);
            return newES;
        }
        return null;
    }

    public IEnchantSet addEnchant(IEnchantSet enchant) {
        if (enchant != null) {
            this.enchants.add((EnchantSet)enchant);
            return enchant;
        }
        return null;
    }

    @Override
    public IEnchantSet addEnchant(int enchantId) {
        return this.addEnchant(Enchantment.func_185262_c((int)enchantId));
    }

    @Override
    public IEnchantSet addEnchant(String enchantName) {
        return this.addEnchant(Enchantment.func_180305_b((String)enchantName));
    }

    public void func_174888_l() {
        this.item = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(ItemStack.field_190927_a);
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    @Override
    @Nonnull
    public IItemStack createLoot(double addChance) {
        ItemStack dItem = this.item.getMCItemStack().func_77946_l();
        int a = this.amount[0];
        if (this.amount[0] != this.amount[1]) {
            a = this.tiedToLevel ? (int)Math.round((double)this.amount[0] + (double)(this.amount[1] - this.amount[0]) * (double)this.npcLevel / (double)CustomNpcs.MaxLv) : (int)Math.round((double)this.amount[0] + (double)(this.amount[1] - this.amount[0]) * Math.random());
        }
        dItem.func_190920_e(a);
        if (dItem.func_77958_k() > 0 && this.damage < 1.0f) {
            int max = dItem.func_77958_k();
            int d = this.tiedToLevel ? Math.round((1.0f - this.damage) * (float)max * (float)this.npcLevel / (float)CustomNpcs.MaxLv) : (int)Math.round((double)((1.0f - this.damage) * (float)max) * Math.random());
            dItem.func_77964_b(d);
        }
        if (!this.enchants.isEmpty()) {
            for (EnchantSet es : this.enchants) {
                if (!(es.chance >= 1.0) && !(es.chance * addChance / 100.0 < Math.random())) continue;
                int lvlM = es.getMinLevel();
                int lvlN = es.getMaxLevel();
                if (lvlM == 0 && lvlN == 0) continue;
                int lvl = lvlM;
                if (lvlM != lvlN) {
                    lvl = this.tiedToLevel ? (int)Math.round((double)lvlM + (double)(lvlN - lvlM) * (double)this.npcLevel / (double)CustomNpcs.MaxLv) : (int)Math.round((double)lvlM + (double)(lvlN - lvlM) * Math.random());
                }
                dItem.func_77966_a(es.ench, lvl);
            }
        }
        if (!this.attributes.isEmpty()) {
            for (AttributeSet as : this.attributes) {
                if (!(as.chance >= 1.0) && !(as.chance * addChance / 100.0 < Math.random())) continue;
                double vM = as.getMinValue();
                double vN = as.getMaxValue();
                if (vM == 0.0 && vN == 0.0) continue;
                double v = vM;
                if (vM != vN) {
                    v = this.tiedToLevel ? (double)Math.round((vM + (vN - vM) * (double)this.npcLevel / (double)CustomNpcs.MaxLv) * 10000.0) / 10000.0 : (double)Math.round((vM + (vN - vM) * Math.random()) * 10000.0) / 10000.0;
                }
                Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(dItem).setAttribute(as.getAttribute(), v, as.getSlot());
            }
        }
        if (!this.tags.isEmpty()) {
            NBTTagCompound tag = dItem.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                dItem.func_77982_d(tag);
            }
            for (DropNbtSet dns : this.tags) {
                if (dns.values.length <= 0 || !(dns.chance >= 1.0) && !(dns.chance * addChance / 100.0 < Math.random())) continue;
                tag = dns.getConstructoredTag(new NBTWrapper(tag)).getMCNBT();
            }
        }
        if (dItem.func_77942_o() && dItem.func_77978_p() != null && dItem.func_77978_p().func_150296_c().isEmpty()) {
            dItem.func_77982_d(null);
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(dItem);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        if (index == 0) {
            ItemStack it;
            if (this.item.getMCItemStack().func_190916_E() <= count) {
                it = this.item.getMCItemStack().func_77946_l();
                this.item = ItemStackWrapper.AIR;
            } else {
                this.item.getMCItemStack().func_77979_a(count);
                it = this.item.getMCItemStack().func_77946_l();
                if (this.item.getMCItemStack().func_190916_E() == 0) {
                    this.item = ItemStackWrapper.AIR;
                }
            }
            return it;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IAttributeSet[] getAttributeSets() {
        IAttributeSet[] ass = new IAttributeSet[this.attributes.size()];
        int i = 0;
        for (AttributeSet as : this.attributes) {
            ass[i] = as;
            ++i;
        }
        return ass;
    }

    @Override
    public double getChance() {
        return (double)Math.round(this.chance * 10000.0) / 10000.0;
    }

    @Override
    public float getDamage() {
        return this.damage;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    @Override
    public IDropNbtSet[] getDropNbtSets() {
        IDropNbtSet[] nts = new IDropNbtSet[this.tags.size()];
        int i = 0;
        for (DropNbtSet ts : this.tags) {
            nts[i] = ts;
            ++i;
        }
        return nts;
    }

    @Override
    public IEnchantSet[] getEnchantSets() {
        IEnchantSet[] ess = new IEnchantSet[this.enchants.size()];
        int i = 0;
        for (EnchantSet es : this.enchants) {
            ess[i] = es;
            ++i;
        }
        return ess;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public int func_174890_g() {
        return 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public IItemStack getItem() {
        return this.item;
    }

    @Override
    public int getLootMode() {
        return this.lootMode;
    }

    @Override
    public int getMaxAmount() {
        return this.amount[1];
    }

    @Override
    public int getMinAmount() {
        return this.amount[0];
    }

    @Nonnull
    public String func_70005_c_() {
        return "NPC Drop";
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound nbtDS = new NBTTagCompound();
        nbtDS.func_74782_a("Item", (NBTBase)this.item.getMCItemStack().func_77955_b(new NBTTagCompound()));
        nbtDS.func_74780_a("Chance", this.chance);
        nbtDS.func_74780_a("DamageToItem", (double)this.damage);
        nbtDS.func_74768_a("LootMode", this.lootMode);
        nbtDS.func_74757_a("TiedToLevel", this.tiedToLevel);
        nbtDS.func_74768_a("QuestId", this.questId);
        nbtDS.func_74783_a("Amount", this.amount);
        NBTTagList ench = new NBTTagList();
        for (EnchantSet enchantSet : this.enchants) {
            ench.func_74742_a((NBTBase)enchantSet.getNBT());
        }
        nbtDS.func_74782_a("EnchantSettings", (NBTBase)ench);
        NBTTagList attr = new NBTTagList();
        for (AttributeSet as : this.attributes) {
            attr.func_74742_a((NBTBase)as.getNBT());
        }
        nbtDS.func_74782_a("AttributeSettings", (NBTBase)attr);
        NBTTagList nBTTagList = new NBTTagList();
        for (DropNbtSet ts : this.tags) {
            nBTTagList.func_74742_a((NBTBase)ts.getNBT());
        }
        nbtDS.func_74782_a("TagSettings", (NBTBase)nBTTagList);
        nbtDS.func_74768_a("Slot", this.pos);
        return nbtDS;
    }

    @Override
    public int getQuestID() {
        return this.questId;
    }

    public int func_70302_i_() {
        return 1;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        if (index == 0) {
            return ItemStackWrapper.MCItem(this.item);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean getTiedToLevel() {
        return this.tiedToLevel;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_191420_l() {
        return NoppesUtilServer.IsItemStackNull(this.item.getMCItemStack()) || this.item.isEmpty();
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return true;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return true;
    }

    public void load(NBTTagCompound nbtDS) {
        this.item = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(nbtDS.func_74775_l("Item")));
        this.chance = nbtDS.func_74769_h("Chance");
        this.damage = nbtDS.func_74760_g("DamageToItem");
        if (nbtDS.func_150297_b("LootMode", 1)) {
            this.lootMode = nbtDS.func_74767_n("LootMode") ? 1 : 0;
        } else if (nbtDS.func_150297_b("LootMode", 3)) {
            this.lootMode = nbtDS.func_74762_e("LootMode");
        }
        this.tiedToLevel = nbtDS.func_74767_n("TiedToLevel");
        this.questId = nbtDS.func_74762_e("QuestId");
        int[] cnts = nbtDS.func_74759_k("Amount");
        if (nbtDS.func_150297_b("Amount", 9)) {
            cnts = new int[2];
            for (int i = 0; i < 2; ++i) {
                cnts[i] = nbtDS.func_150295_c("Amount", 3).func_186858_c(i);
            }
        }
        if (cnts.length != 2) {
            int m = 1;
            int n = 1;
            if (cnts.length >= 1) {
                m = cnts[0];
            }
            if (cnts.length >= 2) {
                n = cnts[1];
            }
            cnts = new int[]{m, n};
        }
        ArrayList<EnchantSet> ench = new ArrayList<EnchantSet>();
        for (Object ne : nbtDS.func_150295_c("EnchantSettings", 10)) {
            EnchantSet es = new EnchantSet(this);
            es.load((NBTTagCompound)ne);
            ench.add(es);
        }
        this.enchants = ench;
        ArrayList<AttributeSet> attr = new ArrayList<AttributeSet>();
        for (NBTBase na : nbtDS.func_150295_c("AttributeSettings", 10)) {
            AttributeSet as = new AttributeSet(this);
            as.load((NBTTagCompound)na);
            attr.add(as);
        }
        this.attributes = attr;
        ArrayList<DropNbtSet> tgsl = new ArrayList<DropNbtSet>();
        for (NBTBase na : nbtDS.func_150295_c("TagSettings", 10)) {
            DropNbtSet ts = new DropNbtSet(this);
            ts.load((NBTTagCompound)na);
            tgsl.add(ts);
        }
        this.tags = tgsl;
        this.pos = nbtDS.func_74762_e("Slot");
        this.setAmount(cnts[0], cnts[1]);
    }

    public void func_70296_d() {
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    @Override
    public void remove() {
        if (this.npcInv != null) {
            this.npcInv.removeDrop(this);
        }
    }

    @Override
    public void removeAttribute(IAttributeSet attribute) {
        this.attributes.remove((AttributeSet)attribute);
    }

    @Override
    public void removeDropNbt(IDropNbtSet nbt) {
        this.tags.remove((DropNbtSet)nbt);
    }

    @Override
    public void removeEnchant(IEnchantSet enchant) {
        this.enchants.remove((EnchantSet)enchant);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        if (index == 0) {
            ItemStack it = this.item.getMCItemStack();
            this.item = ItemStackWrapper.AIR;
            return it;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void resetTo(IItemStack item) {
        NBTTagCompound itemNbt;
        if (item == null) {
            return;
        }
        if (item.isEmpty()) {
            return;
        }
        double ch = 85.0;
        this.damage = 1.0f;
        this.lootMode = 0;
        this.tiedToLevel = false;
        this.enchants = new ArrayList<EnchantSet>();
        this.attributes = new ArrayList<AttributeSet>();
        this.tags = new ArrayList<DropNbtSet>();
        if (item.getAttackDamage() > 1.0) {
            this.damage = item.getItemDamage() == item.getMaxItemDamage() ? 1.0f : (float)Math.round((double)item.getItemDamage() / (double)item.getMaxItemDamage() * 100.0) / 100.0f;
        }
        this.amount = new int[]{1, 1};
        if (item.getStackSize() > 1) {
            this.amount[1] = item.getStackSize();
        }
        if ((itemNbt = item.getNbt().getMCNBT()).func_74764_b("ench")) {
            this.lootMode = 2;
            ch /= (double)itemNbt.func_150295_c("ench", 10).func_74745_c();
            for (NBTBase nbtEnch : itemNbt.func_150295_c("ench", 10)) {
                IEnchantSet es = this.addEnchant(((NBTTagCompound)nbtEnch).func_74765_d("id"));
                if (es == null) continue;
                es.setLevels(0, ((NBTTagCompound)nbtEnch).func_74765_d("lvl"));
                es.setChance(85.0 / (double)itemNbt.func_150295_c("ench", 10).func_74745_c());
            }
            itemNbt.func_82580_o("ench");
        }
        if (itemNbt.func_74764_b("AttributeModifiers")) {
            this.lootMode = 2;
            ch /= (double)itemNbt.func_150295_c("AttributeModifiers", 10).func_74745_c();
            for (NBTBase nbtAttr : itemNbt.func_150295_c("AttributeModifiers", 10)) {
                IAttributeSet as = this.addAttribute(((NBTTagCompound)nbtAttr).func_74779_i("AttributeName"));
                if (as == null) continue;
                int slot = -1;
                if (this.attributeSlotsName.containsKey(((NBTTagCompound)nbtAttr).func_74779_i("Slot"))) {
                    slot = this.attributeSlotsName.get(((NBTTagCompound)nbtAttr).func_74779_i("Slot"));
                }
                as.setSlot(slot);
                double value = ((NBTTagCompound)nbtAttr).func_74769_h("Amount");
                if (value < 0.0) {
                    as.setValues(value, 0.0);
                } else if (value > 0.0) {
                    as.setValues(0.0, value);
                } else {
                    as.setValues(0.0, 0.05);
                }
                as.setChance(85.0 / (double)itemNbt.func_150295_c("AttributeModifiers", 10).func_74745_c());
            }
            itemNbt.func_82580_o("AttributeModifiers");
        }
        this.setChance(ch);
        NBTTagCompound itemFromNbt = new NBTTagCompound();
        item.getMCItemStack().func_77955_b(itemFromNbt);
        itemFromNbt.func_74782_a("tag", (NBTBase)itemNbt);
        IItemStack newItem = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(itemFromNbt));
        newItem.setStackSize(1);
        if (newItem.getAttackDamage() > 1.0) {
            newItem.setItemDamage(0);
        }
        this.item = newItem;
    }

    @Override
    public void setAmount(int min, int max) {
        int newMin = min;
        int newMax = max;
        if (min > max) {
            newMin = max;
            newMax = min;
        }
        if (newMin < 1) {
            newMin = 1;
        }
        if (newMin > this.item.getMaxStackSize()) {
            newMin = this.item.getMaxStackSize();
        }
        if (newMax < newMin) {
            newMax = newMin;
        }
        if (newMax > this.item.getMaxStackSize()) {
            newMax = this.item.getMaxStackSize();
        }
        this.amount[0] = newMin;
        this.amount[1] = newMax;
    }

    @Override
    public void setChance(double chance) {
        double newChance = ValueUtil.correctDouble(chance, 1.0E-4, 100.0);
        this.chance = (double)Math.round(newChance * 10000.0) / 10000.0;
    }

    @Override
    public void setDamage(float dam) {
        this.damage = ValueUtil.correctFloat(dam, 0.0f, 1.0f);
    }

    public void func_174885_b(int id, int value) {
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        if (index == 0) {
            this.item = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack);
        }
    }

    @Override
    public void setItem(IItemStack item) {
        this.item = item;
    }

    @Override
    public void setLootMode(int mode) {
        this.lootMode = mode % 3;
    }

    @Override
    public void setQuestID(int id) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (IQuestCategory cat : Objects.requireNonNull(NpcAPI.Instance()).getQuests().categories()) {
            for (IQuest q : cat.quests()) {
                ids.add(q.getId());
            }
        }
        if (ids.contains(id)) {
            this.questId = id;
        }
    }

    @Override
    public void setTiedToLevel(boolean tied) {
        this.tiedToLevel = tied;
    }

    public String getKey() {
        char c = '\u00a7';
        if (this.item == null) {
            return "null";
        }
        if (this.item.isEmpty()) {
            return "type.empty";
        }
        String keyName = c + "7" + (this.pos + 1) + ": ";
        double ch = (double)Math.round(this.chance * 10.0) / 10.0;
        String chance = String.valueOf(ch).replace(".", ",");
        if (ch == (double)((int)ch)) {
            chance = String.valueOf((int)ch);
        }
        chance = chance + "%";
        keyName = keyName + c + "e" + chance;
        keyName = this.amount[0] == this.amount[1] ? keyName + c + "7[" + c + "6" + this.amount[0] + c + "7]" : keyName + c + "7[" + c + "6" + this.amount[0] + c + "7-" + c + "6" + this.amount[1] + c + "7]";
        String effs = "";
        if (!this.enchants.isEmpty()) {
            effs = c + "7 |" + c + "bE" + c + "7|";
        }
        if (!this.attributes.isEmpty()) {
            if (effs.isEmpty()) {
                effs = effs + c + "7 |";
            }
            effs = effs + c + "aA" + c + "7|";
        }
        if (!this.tags.isEmpty()) {
            if (effs.isEmpty()) {
                effs = effs + c + "7 |";
            }
            effs = effs + c + "cT" + c + "7|";
        }
        keyName = keyName + effs + " " + c + "r" + this.item.getDisplayName();
        if (this.pos < 0) {
            keyName = keyName + c + "8 ID:" + this.toString().substring(this.toString().indexOf("@") + 1);
        }
        return keyName;
    }

    public List<String> getHover(EntityPlayer player) {
        ArrayList<String> list = new ArrayList<String>();
        char c = '\u00a7';
        if (this.pos < 0) {
            list.add(c + "7-" + c + "8 ID:" + this.toString().substring(this.toString().indexOf("@") + 1));
        } else {
            list.add(c + "7- ID: " + c + "r" + this.pos);
        }
        String itemString = Util.instance.translateGoogle(player, "Item");
        if (this.item == null) {
            list.add(c + "7- " + itemString + ": " + c + "4null");
        } else if (this.item.isEmpty()) {
            list.add(c + "7- " + itemString + ": " + c + "cEmpty");
        } else {
            list.add(c + "7- " + itemString + ": " + c + "r" + this.item.getMCItemStack().func_77973_b().getRegistryName());
        }
        String amountString = Util.instance.translateGoogle(player, "Amount");
        if (this.amount[0] == this.amount[1]) {
            list.add(c + "7- " + amountString + ": " + c + "6" + this.amount[0]);
        } else {
            list.add(c + "7- " + amountString + ": " + c + "7[min:" + c + "6" + this.amount[0] + c + "7; max:" + c + "6" + this.amount[1] + c + "7]");
        }
        String chanceString = Util.instance.translateGoogle(player, "Chance");
        if (this.chance == (double)((int)this.chance)) {
            list.add(c + "7- " + chanceString + ": " + c + "e" + (int)this.chance + c + "7%");
        } else {
            list.add(c + "7- " + chanceString + ": " + c + "e" + ("" + this.chance).replace(".", ",") + c + "7%");
        }
        String lootString = Util.instance.translateGoogle(player, "Loot");
        if (this.lootMode == 1) {
            list.add(c + "7- " + lootString + ": " + c + "r" + Util.instance.translateGoogle(player, "Will fall to the ground"));
        } else if (this.lootMode == 2) {
            list.add(c + "7- " + lootString + ": " + c + "r" + Util.instance.translateGoogle(player, "Will be placed in the inventory available when the NPC dies."));
        } else {
            list.add(c + "7- " + lootString + ": " + c + "r" + Util.instance.translateGoogle(player, "Will fall to the player who killed this NPC"));
        }
        String damageString = Util.instance.translateGoogle(player, "Broken");
        if (this.damage == 1.0f) {
            list.add(c + "7- " + damageString + ": (max. meta): " + c + "r" + Util.instance.translateGoogle(player, "Doesn't change"));
        } else {
            list.add(c + "7- " + damageString + " (max. meta): " + c + "6" + ("" + (float)Math.round(this.damage * 10000.0f) / 100.0f).replace(".", ",") + c + "7% from " + c + "6" + (this.item == null ? "0" : Integer.valueOf(this.item.getMaxItemDamage())));
        }
        if (this.tiedToLevel) {
            list.add(c + "7- " + Util.instance.translateGoogle(player, "NPC level is taken into account. Average: ") + c + "6" + this.npcLevel);
        } else {
            list.add(c + "7- " + Util.instance.translateGoogle(player, "NPC level does not affect parameters"));
        }
        if (this.questId > 0) {
            String quest = c + "7- " + Util.instance.translateGoogle(player, "Quest") + " ID: " + c + "2" + this.questId;
            Quest q = QuestController.instance.quests.get(this.questId);
            if (q != null) {
                quest = quest + c + "7; Name: " + c + "r" + q.getTitle();
            }
            list.add(quest);
        } else {
            list.add(c + "7- " + Util.instance.translateGoogle(player, "Quest ID not specified"));
        }
        if (!this.enchants.isEmpty()) {
            StringBuilder ench = new StringBuilder();
            for (EnchantSet es : this.enchants) {
                if (ench.length() > 0) {
                    ench.append(c).append("7, ");
                }
                ench.append(es.ench == null ? "null" : c + "7id: " + c + "b" + Enchantment.func_185258_b((Enchantment)es.ench));
            }
            list.add(c + "7- " + Util.instance.translateGoogle(player, "Enchants") + ": [" + ench + c + "7]");
        } else {
            list.add(c + "7- " + Util.instance.translateGoogle(player, "\"Enchants\" - not specified"));
        }
        if (!this.attributes.isEmpty()) {
            StringBuilder attr = new StringBuilder();
            for (AttributeSet as : this.attributes) {
                if (attr.length() > 0) {
                    attr.append(c).append("7, ");
                }
                attr.append(as.attr == null ? "null" : c + "9" + as.attr.func_111108_a());
            }
            list.add(c + "7- " + Util.instance.translateGoogle(player, "Attributes") + ": [" + attr + c + "7]");
        } else {
            list.add(c + "7- " + Util.instance.translateGoogle(player, "\"Attributes\" - not specified"));
        }
        if (!this.tags.isEmpty()) {
            StringBuilder nbt = new StringBuilder();
            for (DropNbtSet ns : this.tags) {
                if (nbt.length() > 0) {
                    nbt.append(c).append("7, ");
                }
                nbt.append(ns.path == null ? "null" : c + "a" + ns.path);
            }
            list.add(c + "7- " + Util.instance.translateGoogle(player, "Tags") + ": [" + nbt + c + "7]");
        } else {
            list.add(c + "7- " + Util.instance.translateGoogle(player, "\"NBT tags\" - not specified"));
        }
        return list;
    }
}

